﻿<%@ Page Title="Framework Data" Language="C#" MasterPageFile="~/Site.Master" AutoEventWireup="true" CodeBehind="FrameworkData.aspx.cs" Inherits="VIRP_WEB.Cohorts.FrameworkData" %>
<asp:Content ID="Content1" ContentPlaceHolderID="HeadContent" runat="server">
</asp:Content>
<asp:Content ID="Content2" ContentPlaceHolderID="MainContent" runat="server">
    <asp:Label ID="lblPageTitle" runat="server" Text="Framework Data" Font-Size="X-Large" />
    <br /><br />
    <asp:Label ID="lblResult" runat="server" ForeColor="Red" />

    <asp:UpdatePanel ID="UpdatePanel1" runat="server">
        <ContentTemplate>

            <asp:Table ID="tblCategories" runat="server">
                <asp:TableRow>
                    <asp:TableCell HorizontalAlign="Center">Available Categories</asp:TableCell>
                    <asp:TableCell HorizontalAlign="Center">&nbsp;</asp:TableCell>
                    <asp:TableCell HorizontalAlign="Center">Selected Categories</asp:TableCell>
                </asp:TableRow>
                <asp:TableRow>
                    <asp:TableCell>
                        <asp:ListBox ID="listSource" runat="server" Width="200px" Rows="10" SelectionMode="Multiple" />
                    </asp:TableCell>
                    <asp:TableCell HorizontalAlign="Center" VerticalAlign="Middle" Width="200px">
                        <asp:Button ID="btnAddAll" runat="server" Text="Add All ►►" ToolTip="Add all available categories to the selected categories list" Width="150" OnClick="BtnAddAll_Click" /><br /><br />
                        <asp:Button ID="btnAddOne" runat="server" Text="Add Selected ►" ToolTip="Add only the selected categories to the selected list " Width="150" OnClick="BtnAddOne_Click" /><br /><br />
                        <asp:Button ID="btnRemOne" runat="server" Text="Remove Selected ◄" ToolTip="Remove only the selected categories from the selected list" Width="150" OnClick="BtnRemOne_Click" /><br /><br />
                        <asp:Button ID="btnRemAll" runat="server" Text="Remove All ◄◄" ToolTip="Remove all selected categories from the selected categories list" Width="150" OnClick="BtnRemAll_Click" />
                    </asp:TableCell>
                    <asp:TableCell>
                        <asp:ListBox ID="listDestination" runat="server" Width="200px" Rows="10" SelectionMode="Multiple" />
                    </asp:TableCell>
                </asp:TableRow>
            </asp:Table>

            <br /><br />
        </ContentTemplate>
    </asp:UpdatePanel>

    <asp:UpdateProgress ID="UpdateProgress1" AssociatedUpdatePanelID="UpdatePanel1" runat="server" DisplayAfter="0"> 
    <ProgressTemplate> 
<        <div id="modalDiv" class="delayModalStyle" style="position:fixed; height:100%; width: 100%; top:0; left:0; z-index: 100;"> 
        &nbsp; 
        </div>
        <div id="delayIndicatorDiv" class="delayIndicatorStyle" style="position:fixed; top:50%; left:40%; z-index:1003;"> 
            <img alt="" src="../Images/ajax-loader.gif" />
            Processing request. Please wait.
        </div> 
    </ProgressTemplate> 
    </asp:UpdateProgress>

    <br />

    <asp:Table ID="tblForm2" runat="server" style="width:100%; display:inline;">
        <asp:TableRow>
            <asp:TableCell Width="30%">
                <asp:Button ID="btnBack" runat="server" Text="Back" ToolTip="Select to save and go back" OnClick="BtnBack_Click" OnClientClick='return confirm("This will save your Framework Data selections and may take several seconds to process.  Select OK to save selections or Cancel to stop.");' />
            </asp:TableCell>
            <asp:TableCell Width="40%" HorizontalAlign="Center">
                <asp:Button ID="btnSave1" runat="server" Text="Save" OnClick="BtnSave_Click" ToolTip="Select to save selected framework data" OnClientClick='return confirm("This will save your Framework Data selections and may take several seconds to process.  Select OK to save selections or Cancel to stop.");' />
                &nbsp;&nbsp;
                <asp:Button ID="btnReset" runat="server" Text="Reset" OnClick="BtnReset_Click" ToolTip="Select to clear or undo changes made to framework data" />
            </asp:TableCell>
            <asp:TableCell Width="33%" HorizontalAlign="Right">
                <asp:Button ID="btnNext" runat="server" Text="Next" ToolTip="Select to save and continue" OnClick="BtnNext_Click" OnClientClick='return confirm("This will save your Framework Data selections and may take several seconds to process.  Select OK to save selections or Cancel to stop.");' />
            </asp:TableCell>
        </asp:TableRow>
    </asp:Table>

</asp:Content>
